/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.model;

import com.aptana.core.IFilter;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.IndexUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.js.core.model.BaseElement;
import com.aptana.js.core.model.EventElement;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.PropertyElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeElement
extends BaseElement {
    private static final String FUNCTIONS_PROPERTY = "functions";
    private static final String PROPERTIES_PROPERTY = "properties";
    private static final String EVENTS_PROPERTY = "events";
    private static final String EXAMPLES_PROPERTY = "examples";
    private static final String REMARKS_PROPERTY = "remarks";
    private static final String IS_INTERNAL_PROPERTY = "internal";
    private List<String> _parentTypes;
    private List<PropertyElement> _properties;
    private List<EventElement> _events;
    private List<String> _examples;
    private List<String> _remarks;
    private boolean _serializeProperties;
    private boolean _isInternal;

    public void addEvent(EventElement event) {
        if (event != null) {
            if (this._events == null) {
                this._events = new ArrayList<EventElement>();
            }
            this._events.add(event);
            event.setOwningType(this.getName());
        }
    }

    public void addExample(String example) {
        if (example != null && example.length() > 0) {
            if (this._examples == null) {
                this._examples = new ArrayList<String>();
            }
            this._examples.add(example);
        }
    }

    public void addParentType(String type) {
        if (type != null && type.length() > 0) {
            if (this._parentTypes == null) {
                this._parentTypes = new ArrayList<String>();
            }
            if (!this._parentTypes.contains(type) && !type.equals(this.getName())) {
                this._parentTypes.add(type);
            }
        }
    }

    public void addProperty(PropertyElement property) {
        if (property != null) {
            if (this._properties == null) {
                this._properties = new ArrayList<PropertyElement>();
            }
            this._properties.add(property);
            property.setOwningType(this.getName());
        }
    }

    public void addRemark(String remark) {
        if (remark != null && remark.length() > 0) {
            if (this._remarks == null) {
                this._remarks = new ArrayList<String>();
            }
            this._remarks.add(remark);
        }
    }

    @Override
    public void fromJSON(Map object) {
        List remarks;
        List examples;
        List events;
        List functions;
        List properties;
        super.fromJSON(object);
        if (object.containsKey(PROPERTIES_PROPERTY) && !CollectionsUtil.isEmpty((Collection)(properties = IndexUtil.createList(object.get(PROPERTIES_PROPERTY), PropertyElement.class)))) {
            for (PropertyElement property : properties) {
                this.addProperty(property);
            }
        }
        if (object.containsKey(FUNCTIONS_PROPERTY) && !CollectionsUtil.isEmpty((Collection)(functions = IndexUtil.createList(object.get(FUNCTIONS_PROPERTY), FunctionElement.class)))) {
            for (FunctionElement function : functions) {
                this.addProperty(function);
            }
        }
        if (object.containsKey(EVENTS_PROPERTY) && !CollectionsUtil.isEmpty((Collection)(events = IndexUtil.createList(object.get(EVENTS_PROPERTY), EventElement.class)))) {
            for (EventElement event : events) {
                this.addEvent(event);
            }
        }
        if (object.containsKey(EXAMPLES_PROPERTY) && !CollectionsUtil.isEmpty((Collection)(examples = IndexUtil.createList(object.get(EXAMPLES_PROPERTY))))) {
            for (String example : examples) {
                this.addExample(example);
            }
        }
        if (object.containsKey(REMARKS_PROPERTY) && !CollectionsUtil.isEmpty((Collection)(remarks = IndexUtil.createList(object.get(REMARKS_PROPERTY))))) {
            for (String remark : remarks) {
                this.addRemark(remark);
            }
        }
        if (object.containsKey("isInternal")) {
            this.setIsInternal(Boolean.TRUE == object.get("isInternal"));
        } else {
            this.setIsInternal(Boolean.TRUE == object.get(IS_INTERNAL_PROPERTY));
        }
    }

    public List<FunctionElement> getConstructors() {
        ArrayList<FunctionElement> result = new ArrayList<FunctionElement>();
        for (PropertyElement property : this.getProperties()) {
            FunctionElement function;
            if (!(property instanceof FunctionElement) || !(function = (FunctionElement)property).isConstructor()) continue;
            result.add(function);
        }
        return result;
    }

    public List<EventElement> getEvents() {
        return CollectionsUtil.getListValue(this._events);
    }

    public EventElement getEvent(final String eventName) {
        return (EventElement)CollectionsUtil.find(this.getEvents(), (IFilter)new IFilter<EventElement>(){

            public boolean include(EventElement item) {
                return item != null && ObjectUtil.areEqual((Object)eventName, (Object)item.getName());
            }
        });
    }

    public List<String> getExamples() {
        return CollectionsUtil.getListValue(this._examples);
    }

    public List<String> getParentTypes() {
        return CollectionsUtil.getListValue(this._parentTypes);
    }

    public List<PropertyElement> getProperties() {
        return CollectionsUtil.getListValue(this._properties);
    }

    public PropertyElement getProperty(String name) {
        int index = this.getPropertyIndex(name);
        PropertyElement result = null;
        if (index != -1) {
            result = this._properties.get(index);
        }
        return result;
    }

    protected int getPropertyIndex(String name) {
        int result = -1;
        if (name != null && name.length() > 0 && this._properties != null) {
            int i = 0;
            while (i < this._properties.size()) {
                PropertyElement property = this._properties.get(i);
                if (name.equals(property.getName())) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public List<String> getRemarks() {
        return CollectionsUtil.getListValue(this._remarks);
    }

    public boolean getSerializeProperties() {
        return this._serializeProperties;
    }

    public boolean hasParentTypes() {
        return this._parentTypes != null && !this._parentTypes.isEmpty();
    }

    public boolean hasProperties() {
        return this._properties != null && !this._properties.isEmpty();
    }

    public boolean isInternal() {
        return this._isInternal;
    }

    public boolean removeProperty(PropertyElement property) {
        boolean result = false;
        if (this._properties != null) {
            result = this._properties.remove(property);
        }
        return result;
    }

    public void setIsInternal(boolean isInternal) {
        this._isInternal = isInternal;
    }

    public void setSerializeProperties(boolean value) {
        this._serializeProperties = value;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        if (this._serializeProperties) {
            ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>(this.getProperties());
            ArrayList<FunctionElement> functions = new ArrayList<FunctionElement>();
            for (PropertyElement property : properties) {
                if (!(property instanceof FunctionElement)) continue;
                functions.add((FunctionElement)property);
            }
            properties.removeAll(functions);
            out.add(PROPERTIES_PROPERTY, properties);
            out.add(FUNCTIONS_PROPERTY, functions);
            out.add(EVENTS_PROPERTY, this.getEvents());
            out.add(EXAMPLES_PROPERTY, this.getExamples());
            out.add(REMARKS_PROPERTY, this.getRemarks());
            out.add(IS_INTERNAL_PROPERTY, this.isInternal());
        }
    }

    @Override
    public void toSource(SourcePrinter printer) {
        printer.print(this.getName());
        if (this.hasParentTypes()) {
            printer.print(" : ").print(StringUtil.join((String)", ", this.getParentTypes()));
        }
        printer.println().print('{').increaseIndent().println();
        for (PropertyElement property : this.getProperties()) {
            property.toSource(printer);
            printer.println(';');
        }
        for (EventElement event : this.getEvents()) {
            event.toSource(printer);
            printer.println(';');
        }
        printer.decreaseIndent().println('}');
    }

    public String toString() {
        SourcePrinter printer = new SourcePrinter();
        this.toSource(printer);
        return printer.toString();
    }
}

